package ru.yandex.direct.core.entity.banner.type.creative;

import java.util.List;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannerAdditionalActionsContainer;
import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithCreativeModeration;
import ru.yandex.direct.core.entity.banner.service.moderation.BannerWithChildrenModerationProvider;
import ru.yandex.direct.core.entity.banner.service.type.update.AbstractBannerUpdateOperationTypeSupport;
import ru.yandex.direct.core.entity.banner.type.creative.moderation.BannerWithCreativeModerationProcessor;
import ru.yandex.direct.core.entity.banner.type.creative.moderation.DefaultBannerWithCreativeModerationProcessor;
import ru.yandex.direct.model.AppliedChanges;

@Component
public class BannerWithCreativeModerationUpdateOperationTypeSupport
        extends AbstractBannerUpdateOperationTypeSupport<BannerWithCreativeModeration> {

    private BannerWithChildrenModerationProvider<BannerWithCreativeModeration> provider;

    @Autowired
    public BannerWithCreativeModerationUpdateOperationTypeSupport(
            List<BannerWithCreativeModerationProcessor> processors) {
        provider = new BannerWithChildrenModerationProvider<>(DefaultBannerWithCreativeModerationProcessor.class,
                processors);
    }

    @Override
    public Class<BannerWithCreativeModeration> getTypeClass() {
        return BannerWithCreativeModeration.class;
    }

    @Override
    public void beforeExecutionInTransaction(
            DSLContext dsl,
            BannerAdditionalActionsContainer additionalActionsContainer,
            BannersUpdateOperationContainer updateContainer,
            List<AppliedChanges<BannerWithCreativeModeration>> appliedChanges) {
        provider.process(dsl, additionalActionsContainer, updateContainer, appliedChanges);
    }
}
