package ru.yandex.direct.core.entity.banner.type.creative;

import java.util.List;
import java.util.Set;

import one.util.streamex.StreamEx;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersModerationContainer;
import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithCreative;
import ru.yandex.direct.core.entity.banner.model.PerformanceBanner;
import ru.yandex.direct.core.entity.banner.model.TextBanner;
import ru.yandex.direct.core.entity.banner.service.type.update.AbstractBannerUpdateOperationTypeSupport;
import ru.yandex.direct.core.entity.creative.service.CreativeService;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.model.ModelChanges;

import static ru.yandex.direct.model.ModelChanges.getChangedProperty;
import static ru.yandex.direct.model.ModelChanges.isPropertyChanged;
import static ru.yandex.direct.utils.FunctionalUtils.filterList;

@Component
public class BannerWithCreativeUpdateOperationTypeSupport
        extends AbstractBannerUpdateOperationTypeSupport<BannerWithCreative> {

    private final CreativeService creativeService;

    public BannerWithCreativeUpdateOperationTypeSupport(CreativeService creativeService) {
        this.creativeService = creativeService;
    }

    @Override
    public Class<BannerWithCreative> getTypeClass() {
        return BannerWithCreative.class;
    }

    @Override
    public void onModelChangesValidated(BannersUpdateOperationContainer updateContainer,
                                        List<ModelChanges<BannerWithCreative>> validModelChanges) {
        synchronizeTextBannersVideoAdditionCreatives(updateContainer, validModelChanges);
    }

    private void synchronizeTextBannersVideoAdditionCreatives(
            BannersUpdateOperationContainer updateContainer,
            List<ModelChanges<BannerWithCreative>> validModelChanges) {
        List<ModelChanges<BannerWithCreative>> textBannersChanges = filterList(validModelChanges,
                changes -> TextBanner.class.isAssignableFrom(updateContainer.getRuntimeClass(changes.getId())));

        Set<Long> textBannersChangedCreativeIds = StreamEx.of(textBannersChanges)
                .filter(isPropertyChanged(BannerWithCreative.CREATIVE_ID))
                .map(getChangedProperty(BannerWithCreative.CREATIVE_ID))
                .nonNull()
                .toSet();

        if (!textBannersChangedCreativeIds.isEmpty()) {
            creativeService.synchronizeVideoAdditionCreatives(updateContainer.getShard(),
                    updateContainer.getClientId(), textBannersChangedCreativeIds);
        }
    }

    @Override
    public boolean needModeration(BannersModerationContainer container,
                                  AppliedChanges<BannerWithCreative> appliedChanges) {
        boolean isNotTextBanner = !(appliedChanges.getModel() instanceof TextBanner);
        boolean isNotPerformanceBanner = !(appliedChanges.getModel() instanceof PerformanceBanner);
        return isNotTextBanner && isNotPerformanceBanner && appliedChanges.changed(BannerWithCreative.CREATIVE_ID);
    }

    @Override
    public boolean needBsResync(AppliedChanges<BannerWithCreative> appliedChanges) {
        return appliedChanges.changed(BannerWithCreative.CREATIVE_ID);
    }

    @Override
    public boolean needLastChangeReset(AppliedChanges<BannerWithCreative> appliedChanges) {
        return appliedChanges.changed(BannerWithCreative.CREATIVE_ID);
    }
}
