package ru.yandex.direct.core.entity.banner.type.creative;

import java.util.Map;
import java.util.Set;

import ru.yandex.direct.core.entity.banner.container.BannerAdditionalActionsContainer;
import ru.yandex.direct.core.entity.banner.container.BannersOperationContainer;
import ru.yandex.direct.core.entity.banner.model.Banner;
import ru.yandex.direct.core.entity.banner.model.BannerWithCreative;
import ru.yandex.direct.core.entity.banner.model.BannerWithCreativeModeration;
import ru.yandex.direct.core.entity.banner.model.TextBanner;
import ru.yandex.direct.core.entity.banner.model.old.OldBanner;
import ru.yandex.direct.core.entity.creative.model.Creative;
import ru.yandex.direct.core.entity.creative.model.CreativeType;
import ru.yandex.direct.model.AppliedChanges;

import static com.google.common.base.Preconditions.checkNotNull;
import static ru.yandex.direct.core.entity.banner.service.BannerModerationUtils.bannerBecameDraft;
import static ru.yandex.direct.core.entity.banner.service.BannerModerationUtils.moderateUnconditionally;
import static ru.yandex.direct.core.entity.banner.service.BannerTextChangeUtil.isBannerTextChangedSignificantly;
import static ru.yandex.direct.core.entity.banner.service.validation.BannerConstants.OLD_BANNER_TO_NEW_BANNER_CLASS;
import static ru.yandex.direct.core.entity.banner.type.creative.BannerWithCreativeConstants.ALLOWED_CREATIVES_IN_BANNER_CLASS;

public class BannerWithCreativeUtils {

    private BannerWithCreativeUtils() {
    }

    public static boolean isOverlayBanner(BannerWithCreative banner, Map<Long, Creative> creativeByIdMap) {
        Long creativeId = banner.getCreativeId();
        Creative creative = creativeByIdMap.get(creativeId);
        return (creative != null && creative.getType() == CreativeType.CPM_OVERLAY);
    }

    public static boolean isOverlayBanner(Banner banner, Map<Banner, Creative> bannerToCreativeMap) {
        Creative creative = bannerToCreativeMap.get(banner);
        return (creative != null && creative.getType() == CreativeType.CPM_OVERLAY);
    }

    public static boolean isBannerStorage(BannerWithCreative banner, Map<Long, Creative> cpmBannerCreatives) {
        Long creativeId = banner.getCreativeId();
        Creative creative = cpmBannerCreatives.get(creativeId);
        return (creative != null && creative.getType() == CreativeType.BANNERSTORAGE);
    }

    public static boolean needModerateTextBannerCreative(AppliedChanges<BannerWithCreativeModeration> bannerChanges) {
        if (moderateUnconditionally(bannerChanges)) {
            return true;
        }
        return !bannerBecameDraft(bannerChanges)
                && (bannerChanges.changed(TextBanner.CREATIVE_ID)
                || isBannerTextChangedSignificantly(bannerChanges));
    }

    static Set<CreativeType> getAllowedCreativeTypesByClass(
            Class<? extends Banner> newBannerClass,
            Class<? extends OldBanner> oldBannerClass) {
        Class<? extends Banner> bannerClass;
        if (newBannerClass != null) {
            bannerClass = newBannerClass;
        } else {
            bannerClass = OLD_BANNER_TO_NEW_BANNER_CLASS.get(oldBannerClass);
        }
        var allowedCreativeTypes = ALLOWED_CREATIVES_IN_BANNER_CLASS.get(bannerClass);

        checkNotNull(allowedCreativeTypes, "allowed creatives types for banner class must defined in map");
        return allowedCreativeTypes;
    }

    /**
     * специфическая модерация CpmBanner с креативом из BannerStorage
     */
    public static void moderateBannerStorageCreative(
            BannerAdditionalActionsContainer additionalActionsContainer,
            BannerWithCreative banner,
            BannersOperationContainer container) {
        Long creativeId = banner.getCreativeId();
        if (!container.getModerationMode().isForceSaveDraft()) {
            additionalActionsContainer.addCreativeIdToModerate(creativeId);
        }
        additionalActionsContainer.addCreativeIdToSetGeo(creativeId);
    }
}
