package ru.yandex.direct.core.entity.banner.type.creative;

import java.util.Map;
import java.util.Set;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupForBannerOperation;
import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.container.BannersOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithCreative;
import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.campaign.model.CommonCampaign;
import ru.yandex.direct.core.entity.campaign.model.CpmPriceCampaign;
import ru.yandex.direct.core.entity.creative.model.Creative;
import ru.yandex.direct.core.entity.feed.model.BusinessType;
import ru.yandex.direct.core.entity.pricepackage.model.PricePackage;
import ru.yandex.direct.feature.FeatureName;

import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

public class BannerWithCreativeValidationContainer {

    private final BannersOperationContainer commonValidationContainer;

    private final Map<Long, Creative> creativesByIds;

    private final Map<Long, Set<Long>> performanceAdGroupCountriesByAdGroupId;
    private final Map<Long, BusinessType> performanceFeedBusinessTypeByAdGroupId;
    private final Map<Long, Set<Long>> performanceDuplicatedCreativeIdsByAdGroupId;

    private final Map<Long, CpmPriceCampaign> cpmPriceCampaigns;

    private final Map<Long, PricePackage> pricePackages;

    private final Set<String> clientEnabledFeatures;

    private final Set<Long> nonSkippableCpmVideoAdGroupIds;

    BannerWithCreativeValidationContainer(BannersOperationContainer commonValidationContainer,
                                             Map<Long, Creative> creativesByIds,
                                             Map<Long, Set<Long>> performanceAdGroupCountriesByAdGroupId,
                                             Map<Long, BusinessType> performanceFeedBusinessTypeByAdGroupId,
                                             Map<Long, Set<Long>> performanceDuplicatedCreativeIdsByAdGroupId,
                                             Map<Long, CpmPriceCampaign> cpmPriceCampaigns,
                                             Map<Long, PricePackage> pricePackages,
                                             Set<String> clientEnabledFeatures,
                                             Set<Long> nonSkippableCpmVideoAdGroupIds) {
        this.commonValidationContainer = commonValidationContainer;
        this.creativesByIds = creativesByIds;
        this.performanceAdGroupCountriesByAdGroupId = performanceAdGroupCountriesByAdGroupId;
        this.performanceFeedBusinessTypeByAdGroupId = performanceFeedBusinessTypeByAdGroupId;
        this.performanceDuplicatedCreativeIdsByAdGroupId = performanceDuplicatedCreativeIdsByAdGroupId;
        this.cpmPriceCampaigns = cpmPriceCampaigns;
        this.pricePackages = pricePackages;
        this.clientEnabledFeatures = clientEnabledFeatures;
        this.nonSkippableCpmVideoAdGroupIds = nonSkippableCpmVideoAdGroupIds;
    }

    public CampaignType getCampaignType(BannerWithCreative banner) {
        CommonCampaign campaign = commonValidationContainer.getCampaign(banner);
        return ifNotNull(campaign, CommonCampaign::getType);
    }

    public Long getCampaignId(BannerWithCreative banner) {
        CommonCampaign campaign = commonValidationContainer.getCampaign(banner);
        return ifNotNull(campaign, CommonCampaign::getId);
    }

    public AdGroupType getAdGroupType(BannerWithCreative banner) {
        AdGroupForBannerOperation adGroup = commonValidationContainer.getAdGroup(banner);
        return ifNotNull(adGroup, AdGroupForBannerOperation::getType);
    }

    public boolean isNonSkippableCpmVideoAdGroup(BannerWithCreative banner) {
        return nonSkippableCpmVideoAdGroupIds.contains(banner.getAdGroupId());
    }

    public Long getAdGroupId(BannerWithCreative banner) {
        AdGroupForBannerOperation adGroup = commonValidationContainer.getAdGroup(banner);
        return ifNotNull(adGroup, AdGroupForBannerOperation::getId);
    }

    public boolean isCopy() {
        return commonValidationContainer instanceof BannersAddOperationContainer &&
                ((BannersAddOperationContainer) commonValidationContainer).isCopy();
    }

    public Map<Long, Creative> getCreativesByIds() {
        return creativesByIds;
    }

    public Map<Long, Set<Long>> getPerformanceAdGroupCountriesByAdGroupId() {
        return performanceAdGroupCountriesByAdGroupId;
    }

    public Map<Long, BusinessType> getPerformanceFeedBusinessTypeByAdGroupId() {
        return performanceFeedBusinessTypeByAdGroupId;
    }

    public Map<Long, Set<Long>> getPerformanceDuplicatedCreativeIdsByAdGroupId() {
        return performanceDuplicatedCreativeIdsByAdGroupId;
    }

    public Map<Long, CpmPriceCampaign> getCpmPriceCampaigns() {
        return cpmPriceCampaigns;
    }

    public Map<Long, PricePackage> getPricePackages() {
        return pricePackages;
    }

    public boolean isFeatureEnabledForClient(FeatureName featureName) {
        return clientEnabledFeatures.contains(featureName.getName());
    }
}
