package ru.yandex.direct.core.entity.banner.type.creative;

import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.campaign.model.CpmPriceCampaign;
import ru.yandex.direct.core.entity.creative.model.Creative;
import ru.yandex.direct.core.entity.pricepackage.model.PricePackage;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.entity.banner.type.creative.BannerWithCreativeConstraints.checkCreativeFormat;
import static ru.yandex.direct.core.entity.banner.type.creative.BannerWithCreativeConstraints.creativeTypeIsCpmVideoCreative;
import static ru.yandex.direct.core.entity.banner.type.creative.BannerWithCreativeConstraints.creativeTypeIsHtml5;
import static ru.yandex.direct.core.entity.banner.type.creative.BannerWithCreativeConstraints.isAllowedCreativeTemplates;
import static ru.yandex.direct.core.entity.campaign.service.CampaignWithPricePackageUtils.collectCampaignCreativeSizesWithExpand;

@ParametersAreNonnullByDefault
public class CpmBannerCreativePriceSalesValidator implements Validator<Long, Defect> {

    private final Map<Long, Creative> creativesByIds;
    private final CpmPriceCampaign cpmPriceCampaign;

    private final AdGroupType adGroupType;
    private final PricePackage pricePackage;

    public CpmBannerCreativePriceSalesValidator(Map<Long, Creative> creativesByIds,
                                                CpmPriceCampaign cpmPriceCampaign,
                                                AdGroupType adGroupType,
                                                PricePackage pricePackage) {
        this.creativesByIds = creativesByIds;
        this.cpmPriceCampaign = cpmPriceCampaign;
        this.adGroupType = adGroupType;
        this.pricePackage = pricePackage;
    }

    @Override
    public ValidationResult<Long, Defect> apply(Long creativeId) {
        ItemValidationBuilder<Long, Defect> builder = ItemValidationBuilder.of(creativeId);

        if (adGroupType == AdGroupType.CPM_VIDEO) {
            builder
                    .check(creativeTypeIsCpmVideoCreative(creativesByIds), When.isValid())
                    .check(isAllowedCreativeTemplates(creativesByIds, pricePackage.getAllowedCreativeTemplates()), When.isValid());

        } else if (adGroupType == AdGroupType.CPM_BANNER || adGroupType == AdGroupType.CPM_AUDIO) {
            builder
                    .check(isAllowedCreativeTemplates(creativesByIds, pricePackage.getAllowedCreativeTemplates()), When.isValid());

        } else {
            var allowedCreativeSizesWithExpand = collectCampaignCreativeSizesWithExpand(cpmPriceCampaign);

            builder
                    .check(creativeTypeIsHtml5(creativesByIds), When.isValid())
                    .check(checkCreativeFormat(creativesByIds, allowedCreativeSizesWithExpand), When.isValid());
        }

        return builder.getResult();
    }
}
