package ru.yandex.direct.core.entity.banner.type.creative;

import java.util.Map;

import ru.yandex.direct.core.entity.creative.model.Creative;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.entity.banner.type.creative.BannerWithCreativeConstraints.creativeIsNotAdminRejected;

public class CpmGeoPinBannerCreativeValidator implements Validator<Long, Defect> {

    private final Map<Long, Creative> creativesByIds;

    public CpmGeoPinBannerCreativeValidator(Map<Long, Creative> creativesByIds) {
        this.creativesByIds = creativesByIds;
    }


    @Override
    public ValidationResult<Long, Defect> apply(Long creativeId) {
        ItemValidationBuilder<Long, Defect> builder = ItemValidationBuilder.of(creativeId);

        builder
                .check(creativeIsNotAdminRejected(creativesByIds), When.isValid());

        return builder.getResult();
    }
}
