package ru.yandex.direct.core.entity.banner.type.creative;

import java.util.Map;
import java.util.Set;

import ru.yandex.direct.core.entity.creative.model.Creative;
import ru.yandex.direct.core.entity.feed.model.BusinessType;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static java.util.Collections.emptySet;
import static ru.yandex.direct.core.entity.banner.type.creative.BannerWithCreativeConstraints.isCreativeBusinessTypeCorrespondTo;
import static ru.yandex.direct.core.entity.banner.type.creative.BannerWithCreativeConstraints.isCreativeSumGeoCorrespondTo;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notInSet;
import static ru.yandex.direct.validation.defect.CollectionDefects.duplicatedElement;

public class PerformanceBannerCreativeValidator implements Validator<Long, Defect> {


    private final Map<Long, Creative> accessibleCreativesByIds;
    private final Map<Long, BusinessType> feedBusinessTypeByAdGroupId;
    private final Map<Long, Set<Long>> adGroupCountriesByAdGroupId;
    private final Map<Long, Set<Long>> duplicatedCreativeIdsByAdGroupId;
    private final Long adGroupId;

    public PerformanceBannerCreativeValidator(Map<Long, Creative> accessibleCreativesByIds,
                                              Map<Long, BusinessType> feedBusinessTypeByAdGroupId,
                                              Map<Long, Set<Long>> adGroupCountriesByAdGroupId,
                                              Map<Long, Set<Long>> duplicatedCreativeIdsByAdGroupId,
                                              Long adGroupId) {
        this.accessibleCreativesByIds = accessibleCreativesByIds;
        this.feedBusinessTypeByAdGroupId = feedBusinessTypeByAdGroupId;
        this.adGroupCountriesByAdGroupId = adGroupCountriesByAdGroupId;
        this.duplicatedCreativeIdsByAdGroupId = duplicatedCreativeIdsByAdGroupId;
        this.adGroupId = adGroupId;
    }

    @Override
    public ValidationResult<Long, Defect> apply(Long creativeId) {

        BusinessType feedBusinessType = feedBusinessTypeByAdGroupId.get(adGroupId);
        Set<Long> adGroupCountries = adGroupCountriesByAdGroupId.getOrDefault(adGroupId, emptySet());
        // проверяем уникальность креатива в группе с учетом существующих в БД
        Set<Long> duplicatedCreativeIds = duplicatedCreativeIdsByAdGroupId.getOrDefault(adGroupId, emptySet());

        ItemValidationBuilder<Long, Defect> builder = ItemValidationBuilder.of(creativeId);
        builder
                .check(notInSet(duplicatedCreativeIds), duplicatedElement(), When.isValid())
                .check(isCreativeSumGeoCorrespondTo(adGroupCountries, accessibleCreativesByIds), When.isValid());

        if (feedBusinessType != null) {
            builder.check(isCreativeBusinessTypeCorrespondTo(feedBusinessType, accessibleCreativesByIds),
                    When.isValid());
        }

        return builder.getResult();
    }
}
