package ru.yandex.direct.core.entity.banner.type.creative.model;

import java.util.Objects;

public class CreativeSize {
    private final Long width;
    private final Long height;

    public CreativeSize(Long width, Long height) {
        this.width = width;
        this.height = height;
    }

    public Long getWidth() {
        return width;
    }

    public Long getHeight() {
        return height;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (width == null || height == null) {
            return false;
        }
        if (!(obj instanceof CreativeSize)) {
            return false;
        }
        CreativeSize that = (CreativeSize) obj;
        return width.equals(that.width) && height.equals(that.height);
    }

    @Override
    public int hashCode() {
        return Objects.hash(width, height);
    }
}
