package ru.yandex.direct.core.entity.banner.type.creative.model;

import com.google.common.base.Objects;

import ru.yandex.direct.core.entity.creative.model.Creative;

public class CreativeSizeWithExpand {
    private final Long width;
    private final Long height;
    private final Boolean hasExpand;

    public CreativeSizeWithExpand(Long width, Long height, Boolean hasExpand) {
        this.width = width;
        this.height = height;
        this.hasExpand = hasExpand;
    }

    public CreativeSizeWithExpand(Creative creative) {
        this.width = creative.getWidth();
        this.height = creative.getHeight();
        this.hasExpand = creative.getExpandedPreviewUrl() != null;
    }

    public Long getWidth() {
        return width;
    }

    public Long getHeight() {
        return height;
    }

    public Boolean getHasExpand() {
        return hasExpand;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreativeSizeWithExpand that = (CreativeSizeWithExpand) o;
        return Objects.equal(width, that.width) &&
                Objects.equal(height, that.height) &&
                Objects.equal(hasExpand, that.hasExpand);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(width, height, hasExpand);
    }
}
