package ru.yandex.direct.core.entity.banner.type.creative.moderation;

import java.util.List;

import ru.yandex.direct.core.entity.banner.container.BannerAdditionalActionsContainer;
import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerCreativeStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerWithCreativeModeration;
import ru.yandex.direct.core.entity.banner.service.moderation.AbstractBannerWithChildrenModerationProcessor;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.model.BannerWithCreativeModeration.CREATIVE_ID;
import static ru.yandex.direct.core.entity.banner.model.BannerWithCreativeModeration.CREATIVE_STATUS_MODERATE;
import static ru.yandex.direct.core.entity.banner.model.BannerWithCreativeModeration.STATUS_MODERATE;
import static ru.yandex.direct.core.entity.banner.service.BannerModerationUtils.bannerBecameDraft;

public abstract class AbstractBannerWithCreativeModerationProcessor<C>
        extends AbstractBannerWithChildrenModerationProcessor<BannerWithCreativeModeration, C>
        implements BannerWithCreativeModerationProcessor {

    protected abstract C prepareContainer(BannersUpdateOperationContainer container,
                                          List<AppliedChanges<BannerWithCreativeModeration>> appliedChanges);

    @Override
    protected void process(
            BannerAdditionalActionsContainer additionalActionsContainer,
            BannersUpdateOperationContainer container,
            C moderationContainer,
            AppliedChanges<BannerWithCreativeModeration> changes) {
        if (!changes.hasActuallyChangedProps() && container.getModerationMode().isDefault()) {
            return;
        }

        if (bannerBecameDraft(changes)) {
            // Статус модерации связки для черновика всегда черновик
            changes.modify(CREATIVE_STATUS_MODERATE, BannerCreativeStatusModerate.NEW);
            return;
        }

        if (changes.getNewValue(STATUS_MODERATE) == BannerStatusModerate.READY) {
            if (changes.getNewValue(CREATIVE_ID) != null) {
                changes.modify(CREATIVE_STATUS_MODERATE, BannerCreativeStatusModerate.READY);
            }
        }

        processAdditional(additionalActionsContainer, container, moderationContainer, changes);
    }

    protected void processAdditional(
            BannerAdditionalActionsContainer additionalActionsContainer,
            BannersUpdateOperationContainer container,
            C moderationContainer,
            AppliedChanges<BannerWithCreativeModeration> changes) {
    }
}
