package ru.yandex.direct.core.entity.banner.type.creative.moderation;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.banner.container.BannerAdditionalActionsContainer;
import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerCreativeStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerWithCreativeModeration;
import ru.yandex.direct.core.entity.banner.model.CpmBanner;
import ru.yandex.direct.core.entity.banner.service.moderation.DefaultBannerWithChildrenModerationContainer;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.model.BannerWithCreativeModeration.CREATIVE_STATUS_MODERATE;
import static ru.yandex.direct.core.entity.banner.type.creative.BannerWithCreativeUtils.isBannerStorage;
import static ru.yandex.direct.core.entity.banner.type.creative.BannerWithCreativeUtils.isOverlayBanner;
import static ru.yandex.direct.core.entity.banner.type.creative.BannerWithCreativeUtils.moderateBannerStorageCreative;

@Component
public class CpmBannerCreativeModerationProcessor
        extends AbstractBannerWithCreativeModerationDefaultContainerProcessor {

    @Override
    public Class<CpmBanner> getProcessedClass() {
        return CpmBanner.class;
    }

    @Override
    protected void process(BannerAdditionalActionsContainer additionalActionsContainer,
                           BannersUpdateOperationContainer container,
                           DefaultBannerWithChildrenModerationContainer moderationContainer,
                           AppliedChanges<BannerWithCreativeModeration> changes) {

        updateCreativeForBannerStorage(additionalActionsContainer, container, changes);
        super.process(additionalActionsContainer, container, moderationContainer, changes);
    }

    @Override
    protected void processAdditional(
            BannerAdditionalActionsContainer additionalActionsContainer,
            BannersUpdateOperationContainer container,
            DefaultBannerWithChildrenModerationContainer moderationContainer,
            AppliedChanges<BannerWithCreativeModeration> changes) {
        var adGroup = container.getAdGroup(changes.getModel());

        // TODO(временно): баннеры геопродукта не отправляем на модерацию
        if (adGroup.getType() == AdGroupType.CPM_GEOPRODUCT && container.isCpmGeoProductAutoModeration()) {
            changes.modify(CREATIVE_STATUS_MODERATE, BannerCreativeStatusModerate.YES);
        }

        // Оверлейные баннеры не отправляем на модерацию
        if (isOverlayBanner(changes.getModel(), container.getCreativeByIdMap())) {
            changes.modify(CREATIVE_STATUS_MODERATE, BannerCreativeStatusModerate.YES);
        }
    }

    /**
     * специфическая модерация CpmBanner с креативом из BannerStorage
     */
    private void updateCreativeForBannerStorage(BannerAdditionalActionsContainer additionalActionsContainer,
                                                BannersUpdateOperationContainer container,
                                                AppliedChanges<BannerWithCreativeModeration> changes) {

        BannerWithCreativeModeration banner = changes.getModel();
        if (isBannerStorage(banner, container.getCreativeByIdMap())) {
            moderateBannerStorageCreative(additionalActionsContainer, banner, container);
        }
    }
}
