package ru.yandex.direct.core.entity.banner.type.creative.moderation;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.banner.container.BannerAdditionalActionsContainer;
import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerCreativeStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerWithCreativeModeration;
import ru.yandex.direct.core.entity.banner.model.CpmGeoPinBanner;
import ru.yandex.direct.core.entity.banner.service.moderation.DefaultBannerWithChildrenModerationContainer;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.model.BannerWithCreativeModeration.CREATIVE_STATUS_MODERATE;

@Component
public class CpmGeoPinCreativeModerationProcessor
        extends AbstractBannerWithCreativeModerationDefaultContainerProcessor {

    @Override
    public Class<CpmGeoPinBanner> getProcessedClass() {
        return CpmGeoPinBanner.class;
    }

    @Override
    protected void processAdditional(
            BannerAdditionalActionsContainer additionalActionsContainer, BannersUpdateOperationContainer container,
            DefaultBannerWithChildrenModerationContainer moderationContainer,
            AppliedChanges<BannerWithCreativeModeration> changes) {
        var adGroup = container.getAdGroup(changes.getModel());

        if (adGroup.getType() == AdGroupType.CPM_GEO_PIN && container.isCpmGeoPinAutoModeration()) {
            changes.modify(CREATIVE_STATUS_MODERATE, BannerCreativeStatusModerate.YES);
        }
    }
}
