package ru.yandex.direct.core.entity.banner.type.creative.moderation;

import java.util.List;

import org.jooq.DSLContext;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannerAdditionalActionsContainer;
import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerCreativeStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerWithCreativeModeration;
import ru.yandex.direct.core.entity.banner.model.PerformanceBanner;
import ru.yandex.direct.core.entity.banner.service.moderation.ModerationMode;
import ru.yandex.direct.core.entity.campaign.model.CampaignStatusModerate;
import ru.yandex.direct.core.entity.campaign.model.CommonCampaign;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.service.BannerModerationUtils.bannerWasDraft;

/**
 * Креативы для performance баннеров обрабатываются отдельно, не так как для остальных баннеров
 * поэтому не наследуемся от AbstractNewBannerWithCreativeModerationDefaultContainerProcessor
 */
@Component
public class PerformanceBannerCreativeModerationProcessor
        implements BannerWithCreativeModerationProcessor {

    @Override
    public void process(DSLContext dsl,
                        BannerAdditionalActionsContainer additionalActionsContainer,
                        BannersUpdateOperationContainer container,
                        List<AppliedChanges<BannerWithCreativeModeration>> appliedChanges) {
        appliedChanges.forEach(ac -> process(container, additionalActionsContainer, ac));
    }

    private void process(BannersUpdateOperationContainer container,
                         BannerAdditionalActionsContainer additionalActionsContainer,
                         AppliedChanges<BannerWithCreativeModeration> bannerChanges) {
        ModerationMode moderationMode = container.getModerationMode();
        if (!bannerChanges.hasActuallyChangedProps() && moderationMode.isDefault()) {
            return;
        }

        BannerWithCreativeModeration model = bannerChanges.getModel();
        CommonCampaign campaign = container.getCampaign(model);

        boolean bannerWasDraft = bannerWasDraft(bannerChanges);
        boolean campaignIsDraft = campaign.getStatusModerate() == CampaignStatusModerate.NEW;
        boolean saveDraft = moderationMode.isForceSaveDraft() || campaignIsDraft;
        boolean moderateUnconditionally = !campaignIsDraft && bannerWasDraft && moderationMode.isForceModerate();

        boolean needSetCreativeGeo = false;
        boolean needModerateCreative = false;

        if (saveDraft) {
            bannerChanges.modify(PerformanceBanner.CREATIVE_STATUS_MODERATE, BannerCreativeStatusModerate.NEW);
        } else if (moderateUnconditionally) {
            bannerChanges.modify(PerformanceBanner.CREATIVE_STATUS_MODERATE, BannerCreativeStatusModerate.YES);
            needModerateCreative = true;
        }


        if (bannerChanges.changed(PerformanceBanner.CREATIVE_ID)) {
            needSetCreativeGeo = true;
            needModerateCreative = true;
        }

        Long creativeId = model.getCreativeId();
        if (needSetCreativeGeo && creativeId != null) {
            additionalActionsContainer.addCreativeIdToSetGeo(creativeId);
        }
        if (needModerateCreative && creativeId != null
                && model.getStatusModerate() != BannerStatusModerate.NEW) {
            additionalActionsContainer.addCreativeIdToModerate(creativeId);
        }

    }

    @Override
    public Class<PerformanceBanner> getProcessedClass() {
        return PerformanceBanner.class;
    }

}

