package ru.yandex.direct.core.entity.banner.type.creative.moderation;

import java.util.List;
import java.util.Map;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannerAdditionalActionsContainer;
import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerCreativeStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerWithCreativeModeration;
import ru.yandex.direct.core.entity.banner.model.TextBanner;
import ru.yandex.direct.core.entity.moderation.service.ModerationService;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.service.BannerUtils.getCampaignIdToBannerIds;
import static ru.yandex.direct.core.entity.banner.type.creative.BannerWithCreativeUtils.needModerateTextBannerCreative;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Component
public class TextBannerCreativeModerationProcessor
        extends AbstractBannerWithCreativeModerationProcessor<DefaultBannerWithCreativeModerationContainer> {

    private final ModerationService moderationService;

    @Autowired
    public TextBannerCreativeModerationProcessor(ModerationService moderationService) {
        this.moderationService = moderationService;
    }

    @Override
    public Class<TextBanner> getProcessedClass() {
        return TextBanner.class;
    }

    @Override
    protected DefaultBannerWithCreativeModerationContainer prepareContainer(BannersUpdateOperationContainer container,
                                                                            List<AppliedChanges<BannerWithCreativeModeration>> appliedChanges) {
        return new DefaultBannerWithCreativeModerationContainer();
    }

    @Override
    protected void processAdditional(
            BannerAdditionalActionsContainer additionalActionsContainer, BannersUpdateOperationContainer container,
            DefaultBannerWithCreativeModerationContainer moderationContainer,
            AppliedChanges<BannerWithCreativeModeration> changes) {


        if (needModerateTextBannerCreative(changes)) {
            // Видео-дополнение должно отправляться всегда на Модерацию:
            // если изменился текст баннера, который требует модерации
            // видео добавлено/изменено у баннера
            if (changes.getNewValue(TextBanner.CREATIVE_ID) != null) {
                changes.modify(TextBanner.CREATIVE_STATUS_MODERATE, BannerCreativeStatusModerate.READY);
            }
            if (changes.changed(TextBanner.CREATIVE_ID)) {
                moderationContainer.addToModeration(changes.getModel());
            }
        }
    }

    @Override
    protected void postProcess(DSLContext dsl, BannersUpdateOperationContainer container,
                               DefaultBannerWithCreativeModerationContainer moderationContainer) {

        List<BannerWithCreativeModeration> banners = moderationContainer.getBannersVideoAdditionsToModeration();
        Map<Long, List<Long>> campaignIdToBannerIds =
                getCampaignIdToBannerIds(banners, banner -> banner.getCreativeId() == null);
        List<Long> bannerIds = mapList(banners, BannerWithCreativeModeration::getId);

        moderationService.clearVideoAdditionsModeration(dsl, container.getClientId(), bannerIds, campaignIdToBannerIds);
    }
}
