package ru.yandex.direct.core.entity.banner.type.displayhref;

import java.util.List;

import org.jooq.Configuration;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.dbschema.ppc.enums.BannerDisplayHrefsStatusmoderate;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_DISPLAY_HREFS;

@Repository
public class BannerDisplayHrefRepository {

    /**
     * Переотправить на модерацию ссылки которые были отправлены (в статусе Sent)
     */
    public void resendToModeration(Configuration configuration, List<Long> bids) {
        if (bids.isEmpty()) {
            return;
        }

        configuration.dsl()
                .update(BANNER_DISPLAY_HREFS)
                .set(BANNER_DISPLAY_HREFS.STATUS_MODERATE, BannerDisplayHrefsStatusmoderate.Ready)
                .where(BANNER_DISPLAY_HREFS.BID.in(bids),
                        BANNER_DISPLAY_HREFS.STATUS_MODERATE.eq(BannerDisplayHrefsStatusmoderate.Sent)
                )
                .execute();
    }
}
