package ru.yandex.direct.core.entity.banner.type.displayhref;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerDisplayHrefStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerWithDisplayHref;
import ru.yandex.direct.core.entity.banner.service.type.add.AbstractBannerAddOperationTypeSupport;

@Component
@ParametersAreNonnullByDefault
public class BannerWithDisplayHrefAddOperationTypeSupport
        extends AbstractBannerAddOperationTypeSupport<BannerWithDisplayHref> {
    @Override
    public Class<BannerWithDisplayHref> getTypeClass() {
        return BannerWithDisplayHref.class;
    }

    @Override
    public void beforeExecution(BannersAddOperationContainer container, List<BannerWithDisplayHref> models) {
        models.forEach(b -> b.setDisplayHrefStatusModerate(
                b.getDisplayHref() == null ? null : BannerDisplayHrefStatusModerate.READY));
    }
}
