package ru.yandex.direct.core.entity.banner.type.displayhref;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithDisplayHref;
import ru.yandex.direct.core.entity.banner.service.validation.type.add.AbstractBannerAddValidationTypeSupport;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
public class BannerWithDisplayHrefAddValidationTypeSupport
        extends AbstractBannerAddValidationTypeSupport<BannerWithDisplayHref> {

    private final BannerWithDisplayHrefValidatorProvider validatorProvider;

    @Autowired
    public BannerWithDisplayHrefAddValidationTypeSupport(
            BannerWithDisplayHrefValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    @Override
    public Class<BannerWithDisplayHref> getTypeClass() {
        return BannerWithDisplayHref.class;
    }

    @Override
    public ValidationResult<List<BannerWithDisplayHref>, Defect> validate(
            BannersAddOperationContainer container, ValidationResult<List<BannerWithDisplayHref>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.bannerWithDisplayHrefValidator())
                .getResult();
    }
}
