package ru.yandex.direct.core.entity.banner.type.displayhref;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannerAdditionalActionsContainer;
import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithDisplayHrefModeration;
import ru.yandex.direct.core.entity.banner.service.moderation.BannerWithChildrenModerationProvider;
import ru.yandex.direct.core.entity.banner.service.type.update.AbstractBannerUpdateOperationTypeSupport;
import ru.yandex.direct.model.AppliedChanges;

@Component
@ParametersAreNonnullByDefault
public class BannerWithDisplayHrefModerationUpdateOperationTypeSupport
        extends AbstractBannerUpdateOperationTypeSupport<BannerWithDisplayHrefModeration> {

    private BannerWithChildrenModerationProvider<BannerWithDisplayHrefModeration> provider;

    @Autowired
    public BannerWithDisplayHrefModerationUpdateOperationTypeSupport(
            List<BannerWithDisplayHrefModerationProcessor<?>> processors) {
        provider = new BannerWithChildrenModerationProvider<>(
                DefaultBannerWithDisplayHrefModerationProcessor.class, processors);
    }

    @Override
    public Class<BannerWithDisplayHrefModeration> getTypeClass() {
        return BannerWithDisplayHrefModeration.class;
    }

    @Override
    public void beforeExecutionInTransaction(DSLContext context,
                                             BannerAdditionalActionsContainer additionalActionsContainer,
                                             BannersUpdateOperationContainer container,
                                             List<AppliedChanges<BannerWithDisplayHrefModeration>> appliedChanges) {
        provider.process(context, additionalActionsContainer, container, appliedChanges);
    }
}
