package ru.yandex.direct.core.entity.banner.type.displayhref;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerDisplayHrefStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerWithDisplayHref;
import ru.yandex.direct.core.entity.banner.repository.type.AbstractFlatRelatedEntityRepositoryTypeSupport;
import ru.yandex.direct.dbschema.ppc.tables.records.BannerDisplayHrefsRecord;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_DISPLAY_HREFS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.direct.jooqmapper.write.WriterBuilders.fromProperty;

@ParametersAreNonnullByDefault
@Component
public class BannerWithDisplayHrefRepositoryTypeSupport
        extends AbstractFlatRelatedEntityRepositoryTypeSupport
        <BannerWithDisplayHref, BannerDisplayHrefsRecord> {

    @Autowired
    public BannerWithDisplayHrefRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider, BANNER_DISPLAY_HREFS.BID, createMapper());
    }

    private static JooqMapper<BannerWithDisplayHref> createMapper() {
        return JooqMapperBuilder.<BannerWithDisplayHref>builder()
                .map(property(BannerWithDisplayHref.DISPLAY_HREF, BANNER_DISPLAY_HREFS.DISPLAY_HREF))
                .map(convertibleProperty(BannerWithDisplayHref.DISPLAY_HREF_STATUS_MODERATE,
                        BANNER_DISPLAY_HREFS.STATUS_MODERATE,
                        BannerDisplayHrefStatusModerate::fromSource,
                        BannerDisplayHrefStatusModerate::toSource))
                .writeField(BANNER_DISPLAY_HREFS.BID, fromProperty(BannerWithDisplayHref.ID))
                .build();
    }

    @Override
    protected boolean isAddEntity(BannerWithDisplayHref banner) {
        return banner.getDisplayHref() != null;
    }

    @Override
    protected boolean isAddEntity(AppliedChanges<BannerWithDisplayHref> appliedChange) {
        return appliedChange.assigned(BannerWithDisplayHref.DISPLAY_HREF);
    }

    @Override
    protected boolean isUpdateEntity(AppliedChanges<BannerWithDisplayHref> appliedChange) {
        return appliedChange.replaced(BannerWithDisplayHref.DISPLAY_HREF) ||
                appliedChange.replaced(BannerWithDisplayHref.DISPLAY_HREF_STATUS_MODERATE);
    }

    @Override
    protected boolean isDeleteEntity(AppliedChanges<BannerWithDisplayHref> appliedChange) {
        return appliedChange.deleted(BannerWithDisplayHref.DISPLAY_HREF);
    }

    @Override
    public Class<BannerWithDisplayHref> getTypeClass() {
        return BannerWithDisplayHref.class;
    }
}
