package ru.yandex.direct.core.entity.banner.type.displayhref;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerWithDisplayHref;
import ru.yandex.direct.core.entity.banner.service.type.update.AbstractBannerUpdateOperationTypeSupport;
import ru.yandex.direct.model.AppliedChanges;

@Component
@ParametersAreNonnullByDefault
public class BannerWithDisplayHrefUpdateOperationTypeSupport
        extends AbstractBannerUpdateOperationTypeSupport<BannerWithDisplayHref> {

    @Override
    public Class<BannerWithDisplayHref> getTypeClass() {
        return BannerWithDisplayHref.class;
    }

    @Override
    public boolean needLastChangeReset(AppliedChanges<BannerWithDisplayHref> appliedChanges) {
        return appliedChanges.changed(BannerWithDisplayHref.DISPLAY_HREF);
    }

    @Override
    public boolean needBsResync(AppliedChanges<BannerWithDisplayHref> appliedChanges) {
        return appliedChanges.deleted(BannerWithDisplayHref.DISPLAY_HREF);
    }
}
