package ru.yandex.direct.core.entity.banner.type.displayhref;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithDisplayHref;
import ru.yandex.direct.core.entity.banner.service.validation.type.update.AbstractBannerUpdateValidationTypeSupport;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class BannerWithDisplayHrefUpdateValidationTypeSupport
        extends AbstractBannerUpdateValidationTypeSupport<BannerWithDisplayHref> {

    private final BannerWithDisplayHrefValidatorProvider validatorProvider;

    @Autowired
    public BannerWithDisplayHrefUpdateValidationTypeSupport(
            BannerWithDisplayHrefValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    @Override
    public Class<BannerWithDisplayHref> getTypeClass() {
        return BannerWithDisplayHref.class;
    }

    @Override
    public ValidationResult<List<BannerWithDisplayHref>, Defect> validate(
            BannersUpdateOperationContainer container, ValidationResult<List<BannerWithDisplayHref>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.bannerWithDisplayHrefValidator())
                .getResult();
    }
}
