package ru.yandex.direct.core.entity.banner.type.displayhref;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerWithDisplayHref;
import ru.yandex.direct.core.entity.banner.model.BannerWithHrefAndDisplayHref;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.banner.service.validation.BannerTextConstraints.templateIsValid;
import static ru.yandex.direct.core.entity.banner.type.displayhref.BannerWithDisplayHrefConstraints.displayHrefCharsAreAllowed;
import static ru.yandex.direct.core.entity.banner.type.displayhref.BannerWithDisplayHrefConstraints.displayHrefHasValidLength;
import static ru.yandex.direct.core.entity.banner.type.displayhref.BannerWithDisplayHrefConstraints.displayHrefIsNotEmpty;
import static ru.yandex.direct.core.entity.banner.type.displayhref.BannerWithDisplayHrefConstraints.displayHrefNotContainsDuplicatedSpecialChars;
import static ru.yandex.direct.core.entity.banner.type.displayhref.BannerWithDisplayHrefConstraints.hrefIsSetIfDisplayHrefNotNull;

@Component
@ParametersAreNonnullByDefault
public class BannerWithDisplayHrefValidatorProvider {
    public Validator<BannerWithDisplayHref, Defect> bannerWithDisplayHrefValidator() {
        return bannerWithDisplayHref -> {
            ModelItemValidationBuilder<BannerWithDisplayHref> ivb =
                    ModelItemValidationBuilder.of(bannerWithDisplayHref);
            ivb.item(BannerWithDisplayHref.DISPLAY_HREF).checkBy(displayHrefValidator(), When.notNull());
            return ivb.getResult();
        };
    }

    public static Validator<String, Defect> displayHrefValidator() {

        return (displayHref) -> ItemValidationBuilder.of(displayHref, Defect.class)
                .check(displayHrefIsNotEmpty())
                .check(displayHrefHasValidLength(), When.isValid())
                .check(displayHrefCharsAreAllowed(), When.isValid())
                .check(displayHrefNotContainsDuplicatedSpecialChars(), When.isValid())
                .check(templateIsValid(), When.isValid())
                .getResult();
    }

    public Validator<BannerWithHrefAndDisplayHref, Defect> bannerWithHrefAndDisplayHrefValidator() {
        return bannerWithHrefAndDisplayHref -> {
            ModelItemValidationBuilder<BannerWithHrefAndDisplayHref> ivb =
                    ModelItemValidationBuilder.of(bannerWithHrefAndDisplayHref);
            ivb.item(BannerWithDisplayHref.DISPLAY_HREF)
                    .check(hrefIsSetIfDisplayHrefNotNull(bannerWithHrefAndDisplayHref));
            return ivb.getResult();
        };
    }
}
