package ru.yandex.direct.core.entity.banner.type.displayhref;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithHrefAndDisplayHref;
import ru.yandex.direct.core.entity.banner.service.validation.type.add.AbstractBannerAddValidationTypeSupport;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
public class BannerWithHrefAndDisplayHrefAddValidationTypeSupport
        extends AbstractBannerAddValidationTypeSupport<BannerWithHrefAndDisplayHref> {

    private final BannerWithDisplayHrefValidatorProvider validatorProvider;

    @Autowired
    public BannerWithHrefAndDisplayHrefAddValidationTypeSupport(
            BannerWithDisplayHrefValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    @Override
    public Class<BannerWithHrefAndDisplayHref> getTypeClass() {
        return BannerWithHrefAndDisplayHref.class;
    }

    @Override
    public ValidationResult<List<BannerWithHrefAndDisplayHref>, Defect> validate(
            BannersAddOperationContainer container, ValidationResult<List<BannerWithHrefAndDisplayHref>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.bannerWithHrefAndDisplayHrefValidator())
                .getResult();
    }
}
