package ru.yandex.direct.core.entity.banner.type.displayhreftexts;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithDisplayHrefTexts;
import ru.yandex.direct.core.entity.banner.service.validation.type.add.AbstractBannerAddValidationTypeSupport;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.entity.banner.type.displayhreftexts.BannerWithDisplayHrefTextsValidatorProvider.bannerWithDisplayHrefTextsValidator;

@Component
@ParametersAreNonnullByDefault
public class BannerWithDisplayHrefTextsAddValidationTypeSupport extends
        AbstractBannerAddValidationTypeSupport<BannerWithDisplayHrefTexts> {

    @Override
    public Class<BannerWithDisplayHrefTexts> getTypeClass() {
        return BannerWithDisplayHrefTexts.class;
    }

    @Override
    public ValidationResult<List<BannerWithDisplayHrefTexts>, Defect> validate(
            BannersAddOperationContainer container,
            ValidationResult<List<BannerWithDisplayHrefTexts>, Defect> vr
    ) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(bannerWithDisplayHrefTextsValidator())
                .getResult();
    }
}
