package ru.yandex.direct.core.entity.banner.type.displayhreftexts;

import java.util.Collection;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.jooq.util.mysql.MySQLDSL;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerWithDisplayHrefTexts;
import ru.yandex.direct.core.entity.banner.repository.type.AbstractFlatRelatedEntityUpsertRepositoryTypeSupport;
import ru.yandex.direct.dbschema.ppc.tables.records.BannerDisplayHrefTextsRecord;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelper;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.model.ModelProperty;

import static ru.yandex.direct.dbschema.ppc.tables.BannerDisplayHrefTexts.BANNER_DISPLAY_HREF_TEXTS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.direct.jooqmapper.write.WriterBuilders.fromProperty;

@Component
@ParametersAreNonnullByDefault
public class BannerWithDisplayHrefTextsRepositoryTypeSupport extends
        AbstractFlatRelatedEntityUpsertRepositoryTypeSupport<BannerWithDisplayHrefTexts, BannerDisplayHrefTextsRecord> {

    public static final Set<ModelProperty<? super BannerWithDisplayHrefTexts, ?>> DISPLAY_HREF_TEXTS_PROPERTIES
            = Set.of(BannerWithDisplayHrefTexts.DISPLAY_HREF_PREFIX, BannerWithDisplayHrefTexts.DISPLAY_HREF_SUFFIX);

    @Autowired
    public BannerWithDisplayHrefTextsRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider, BANNER_DISPLAY_HREF_TEXTS.BID, createMapper());
    }

    private static JooqMapper<BannerWithDisplayHrefTexts> createMapper() {
        return JooqMapperBuilder.<BannerWithDisplayHrefTexts>builder()
                .map(property(BannerWithDisplayHrefTexts.DISPLAY_HREF_PREFIX,
                        BANNER_DISPLAY_HREF_TEXTS.DISPLAY_HREF_PREFIX))
                .map(property(BannerWithDisplayHrefTexts.DISPLAY_HREF_SUFFIX,
                        BANNER_DISPLAY_HREF_TEXTS.DISPLAY_HREF_SUFFIX))
                .writeField(BANNER_DISPLAY_HREF_TEXTS.BID, fromProperty(BannerWithDisplayHrefTexts.ID))
                .build();
    }

    @Override
    protected void upsertEntity(DSLContext context, Collection<BannerWithDisplayHrefTexts> banners) {
        var helper = new InsertHelper<>(context, BANNER_DISPLAY_HREF_TEXTS);
        helper.addAll(getJooqMapper(), banners);

        helper.onDuplicateKeyUpdate()
                .set(BANNER_DISPLAY_HREF_TEXTS.DISPLAY_HREF_PREFIX,
                        MySQLDSL.values(BANNER_DISPLAY_HREF_TEXTS.DISPLAY_HREF_PREFIX))
                .set(BANNER_DISPLAY_HREF_TEXTS.DISPLAY_HREF_SUFFIX,
                        MySQLDSL.values(BANNER_DISPLAY_HREF_TEXTS.DISPLAY_HREF_SUFFIX));

        helper.executeIfRecordsAdded();
    }

    @Override
    protected boolean isAddEntity(BannerWithDisplayHrefTexts banner) {
        return banner.getDisplayHrefPrefix() != null || banner.getDisplayHrefSuffix() != null;
    }

    @Override
    protected boolean isUpsertEntity(AppliedChanges<BannerWithDisplayHrefTexts> appliedChange) {
        return DISPLAY_HREF_TEXTS_PROPERTIES.stream().anyMatch(p -> appliedChange.getNewValue(p) != null)
                && DISPLAY_HREF_TEXTS_PROPERTIES.stream().anyMatch(appliedChange::changed);
    }

    @Override
    protected boolean isDeleteEntity(AppliedChanges<BannerWithDisplayHrefTexts> appliedChange) {
        return DISPLAY_HREF_TEXTS_PROPERTIES.stream().allMatch(p -> appliedChange.getNewValue(p) == null)
                && DISPLAY_HREF_TEXTS_PROPERTIES.stream().anyMatch(appliedChange::changed);
    }

    @Override
    public Class<BannerWithDisplayHrefTexts> getTypeClass() {
        return BannerWithDisplayHrefTexts.class;
    }
}
