package ru.yandex.direct.core.entity.banner.type.displayhreftexts;
import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerWithDisplayHrefTexts;
import ru.yandex.direct.core.entity.banner.service.type.update.AbstractBannerUpdateOperationTypeSupport;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.type.displayhreftexts.BannerWithDisplayHrefTextsRepositoryTypeSupport.DISPLAY_HREF_TEXTS_PROPERTIES;

@Component
@ParametersAreNonnullByDefault
public class BannerWithDisplayHrefTextsUpdateOperationTypeSupport extends
        AbstractBannerUpdateOperationTypeSupport<BannerWithDisplayHrefTexts> {

    @Override
    public Class<BannerWithDisplayHrefTexts> getTypeClass() {
        return BannerWithDisplayHrefTexts.class;
    }

    @Override
    public boolean needBsResync(AppliedChanges<BannerWithDisplayHrefTexts> appliedChanges) {
        return DISPLAY_HREF_TEXTS_PROPERTIES.stream().anyMatch(appliedChanges::changed);
    }

    @Override
    public boolean needLastChangeReset(AppliedChanges<BannerWithDisplayHrefTexts> appliedChanges) {
        return DISPLAY_HREF_TEXTS_PROPERTIES.stream().anyMatch(appliedChanges::changed);
    }
}
