package ru.yandex.direct.core.entity.banner.type.displayhreftexts;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithDisplayHrefTexts;
import ru.yandex.direct.core.entity.banner.service.validation.type.update.AbstractBannerUpdateValidationTypeSupport;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.entity.banner.type.displayhreftexts.BannerWithDisplayHrefTextsValidatorProvider.bannerWithDisplayHrefTextsValidator;

@Component
@ParametersAreNonnullByDefault
public class BannerWithDisplayHrefTextsUpdateValidationTypeSupport extends
        AbstractBannerUpdateValidationTypeSupport<BannerWithDisplayHrefTexts> {

    @Override
    public ValidationResult<List<BannerWithDisplayHrefTexts>, Defect> validate(
            BannersUpdateOperationContainer container,
            ValidationResult<List<BannerWithDisplayHrefTexts>, Defect> vr
    ) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(bannerWithDisplayHrefTextsValidator())
                .getResult();
    }

    @Override
    public Class<BannerWithDisplayHrefTexts> getTypeClass() {
        return BannerWithDisplayHrefTexts.class;
    }
}
