package ru.yandex.direct.core.entity.banner.type.displayhreftexts;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerWithDisplayHrefTexts;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.banner.service.validation.BannerTextConstraints.charsAreAllowed;
import static ru.yandex.direct.validation.constraint.StringConstraints.maxStringLength;
import static ru.yandex.direct.validation.constraint.StringConstraints.notBlank;

@Component
@ParametersAreNonnullByDefault
public class BannerWithDisplayHrefTextsValidatorProvider {

    public static final int MAX_TEXT_LENGTH = 25;

    private BannerWithDisplayHrefTextsValidatorProvider() {
    }

    public static Validator<BannerWithDisplayHrefTexts, Defect> bannerWithDisplayHrefTextsValidator() {
        return (banner) -> {
            ModelItemValidationBuilder<BannerWithDisplayHrefTexts> vb = ModelItemValidationBuilder.of(banner);

            vb.item(BannerWithDisplayHrefTexts.DISPLAY_HREF_PREFIX)
                    .check(notBlank())
                    .check(maxStringLength(MAX_TEXT_LENGTH))
                    .check(charsAreAllowed());

            vb.item(BannerWithDisplayHrefTexts.DISPLAY_HREF_SUFFIX)
                    .check(notBlank())
                    .check(maxStringLength(MAX_TEXT_LENGTH))
                    .check(charsAreAllowed());

            return vb.getResult();
        };
    }
}
