package ru.yandex.direct.core.entity.banner.type.flags;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.Record2;
import org.jooq.Result;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.banner.model.BannerFlags;
import ru.yandex.direct.core.entity.banner.model.FlagProperty;

import static ru.yandex.direct.dbschema.ppc.tables.Banners.BANNERS;

@Repository
public class BannerFlagsRepository {

    public Map<Long, BannerFlags> getBannersWithFlags(Configuration conf, Collection<Long> bids,
                                                      Collection<FlagProperty> flags) {

        if (bids.isEmpty()) {
            return Map.of();
        }

        List<Condition> flagsConditions = new ArrayList<>();

        for (var flag : flags) {
            flagsConditions.add(BANNERS.FLAGS.like("%" + flag.getKey() + "%"));
        }

        Result<Record2<Long, String>> resultSet = DSL.using(conf)
                .select(BANNERS.BID, BANNERS.FLAGS)
                .from(BANNERS)
                .where(
                        BANNERS.BID.in(bids),
                        DSL.or(flagsConditions)
                )
                .fetch();

        Map<Long, BannerFlags> result = new HashMap<>();

        for (var row : resultSet) {
            long bid = row.get(BANNERS.BID);
            BannerFlags parsedFlags = BannerFlags.fromSource(row.get(BANNERS.FLAGS));

            boolean found = false;

            for (var pattern : flags) {
                if (parsedFlags.getFlags().containsKey(pattern.getKey())) {
                    found = true;
                    break;
                }
            }

            if (found) {
                result.put(bid, parsedFlags);
            }
        }

        return result;
    }
}
