package ru.yandex.direct.core.entity.banner.type.flags;

import java.time.LocalDateTime;
import java.util.List;

import org.jooq.DSLContext;
import org.springframework.stereotype.Repository;

import static ru.yandex.direct.dbschema.ppc.tables.BannerUserFlagsUpdates.BANNER_USER_FLAGS_UPDATES;

@Repository
public class BannerUserFlagsUpdatesRepository {
    public void saveBannerUserFlagsUpdateTimestamp(DSLContext dslContext, List<BannerUserFlagsUpdateInfo> updatedBanners) {
        var insert = dslContext
                .insertInto(BANNER_USER_FLAGS_UPDATES)
                .columns(BANNER_USER_FLAGS_UPDATES.BID, BANNER_USER_FLAGS_UPDATES.PID, BANNER_USER_FLAGS_UPDATES.CID);
        updatedBanners.forEach(b -> insert.values(b.getBannerId(), b.getAdGroupId(), b.getCampaignId()));
        insert.onDuplicateKeyUpdate()
                .set(BANNER_USER_FLAGS_UPDATES.UPDATE_TIME, LocalDateTime.now())
                .execute();
    }
}
