package ru.yandex.direct.core.entity.banner.type.flags;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerFlags;
import ru.yandex.direct.core.entity.banner.model.BannerWithFlags;
import ru.yandex.direct.core.entity.banner.repository.type.AbstractBannerDefaultRepositoryTypeSupport;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;

@Component
public class BannerWithFlagsRepositoryTypeSupport
        extends AbstractBannerDefaultRepositoryTypeSupport<BannerWithFlags> {

    @Autowired
    public BannerWithFlagsRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider, BannerWithFlags.FLAGS, BANNERS.FLAGS,
                BannerFlags::fromSource, BannerFlags::toSource);
    }

    @Override
    public Class<BannerWithFlags> getTypeClass() {
        return BannerWithFlags.class;
    }
}
