package ru.yandex.direct.core.entity.banner.type.flags;

import java.util.List;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannerAdditionalActionsContainer;
import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithFlags;
import ru.yandex.direct.core.entity.banner.service.type.update.AbstractBannerUpdateOperationTypeSupport;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.model.BannerWithFlags.FLAGS;

@Component
public class BannerWithFlagsUpdateOperationTypeSupport
        extends AbstractBannerUpdateOperationTypeSupport<BannerWithFlags> {

    @Override
    public Class<BannerWithFlags> getTypeClass() {
        return BannerWithFlags.class;
    }

    @Override
    public void addToAdditionalActionsContainer(BannerAdditionalActionsContainer additionalActionsContainer,
                                                BannersUpdateOperationContainer updateContainer,
                                                List<AppliedChanges<BannerWithFlags>> appliedChanges) {

        appliedChanges.stream()
                .filter(oneChange -> oneChange.changed(FLAGS))
                .forEach(oneChange -> {
                    additionalActionsContainer.addBannerUserFlagsUpdate(new BannerUserFlagsUpdateInfo(
                            oneChange.getModel().getId(),
                            updateContainer.getAdGroup(oneChange.getModel()).getId(),
                            oneChange.getModel().getCampaignId()
                    ));
                });
    }

    @Override
    public boolean needBsResync(AppliedChanges<BannerWithFlags> appliedChanges) {
        return appliedChanges.changed(FLAGS);
    }
}
