package ru.yandex.direct.core.entity.banner.type.flags;

import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithFlags;
import ru.yandex.direct.core.entity.banner.service.validation.type.update.AbstractBannerUpdateValidationTypeSupport;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class BannerWithFlagsUpdateValidationTypeSupport
        extends AbstractBannerUpdateValidationTypeSupport<BannerWithFlags> {
    private final BannerWithFlagsValidatorProvider validatorProvider;

    @Autowired
    public BannerWithFlagsUpdateValidationTypeSupport(BannerWithFlagsValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    @Override
    public Class<BannerWithFlags> getTypeClass() {
        return BannerWithFlags.class;
    }

    @Override
    public ValidationResult<List<ModelChanges<BannerWithFlags>>, Defect> validateBeforeApply(
            BannersUpdateOperationContainer container,
            ValidationResult<List<ModelChanges<BannerWithFlags>>, Defect> vr,
            Map<Long, BannerWithFlags> unmodifiedModels) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider
                                .bannerFlagsChangesValidator(unmodifiedModels, container.getOperatorRole()),
                        When.isValidAnd(When.valueIs(mc -> mc.isPropChanged(BannerWithFlags.FLAGS))))
                .getResult();
    }
}
