package ru.yandex.direct.core.entity.banner.type.geoflag;

import java.util.List;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithOnlyGeoFlag;
import ru.yandex.direct.core.entity.banner.service.type.add.AbstractBannerAddOperationTypeSupport;
import ru.yandex.direct.regions.GeoTree;
import ru.yandex.direct.regions.GeoTreeFactory;

@Component
public class BannerWithOnlyGeoFlagAddOperationTypeSupport
        extends AbstractBannerAddOperationTypeSupport<BannerWithOnlyGeoFlag> {

    private final GeoTreeFactory geoTreeFactory;

    public BannerWithOnlyGeoFlagAddOperationTypeSupport(GeoTreeFactory geoTreeFactory) {
        this.geoTreeFactory = geoTreeFactory;
    }

    @Override
    public Class<BannerWithOnlyGeoFlag> getTypeClass() {
        return BannerWithOnlyGeoFlag.class;
    }

    @Override
    public void beforeExecution(BannersAddOperationContainer addContainer, List<BannerWithOnlyGeoFlag> banners) {
        banners.forEach(banner -> {
            var adGroupInfo = addContainer.getAdGroup(banner);
            var geoFlag = getGeoTree().hasGeoFlagByGeo(adGroupInfo.getGeo());
            banner.withGeoFlag(geoFlag);
        });
    }

    private GeoTree getGeoTree() {
        return geoTreeFactory.getGlobalGeoTree();
    }
}
