package ru.yandex.direct.core.entity.banner.type.href;

import java.util.regex.Pattern;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefects.invalidDomain;
import static ru.yandex.direct.validation.constraint.StringConstraints.DOMAIN_PATTERN;
import static ru.yandex.direct.validation.constraint.StringConstraints.PROTOCOL_PATTERN;
import static ru.yandex.direct.validation.constraint.StringConstraints.matchPattern;

@ParametersAreNonnullByDefault
public class BannerAdvertisingSourceValidator implements Validator<String, Defect> {

    private static final Pattern HREF_PATTERN =
            Pattern.compile("^" + PROTOCOL_PATTERN + DOMAIN_PATTERN + "\\z", Pattern.UNICODE_CHARACTER_CLASS);

    @Override
    public ValidationResult<String, Defect> apply(String href) {
        ItemValidationBuilder<String, Defect> builder = ItemValidationBuilder.of(href);
        return builder
                .check(matchPattern(HREF_PATTERN), invalidDomain())
                .getResult();
    }
}
