package ru.yandex.direct.core.entity.banner.type.href;

import java.util.List;
import java.util.Map;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerWithContentPromotionHref;
import ru.yandex.direct.core.entity.contentpromotion.model.ContentPromotionContent;
import ru.yandex.direct.core.entity.contentpromotion.repository.ContentPromotionRepository;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.model.BannerWithContentPromotionHref.CONTENT_PROMOTION_ID;
import static ru.yandex.direct.core.entity.banner.model.BannerWithContentPromotionHref.HREF;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Component
public class BannerHrefByContentPromotionEvaluator {
    private final ContentPromotionRepository contentPromotionRepository;

    @Autowired
    public BannerHrefByContentPromotionEvaluator(ContentPromotionRepository contentPromotionRepository) {
        this.contentPromotionRepository = contentPromotionRepository;
    }

    public void setBannersHrefsByContentPromotion(ClientId clientId,
                                                  List<BannerWithContentPromotionHref> models) {
        var contentUrls = getContentUrlsByContentIds(clientId, models);
        models.forEach(banner -> banner.setHref(contentUrls.get(banner.getContentPromotionId())));
    }

    public void setBannersChangesHrefsByContentPromotion(
            ClientId clientId, List<AppliedChanges<BannerWithContentPromotionHref>> appliedChanges) {
        var contentUrls = getContentUrlsByContentIds(clientId, mapList(appliedChanges, AppliedChanges::getModel));
        appliedChanges.forEach(ac -> ac.modify(HREF, contentUrls.get(ac.getNewValue(CONTENT_PROMOTION_ID))));
    }

    private Map<Long, String> getContentUrlsByContentIds(ClientId clientId,
                                                         List<BannerWithContentPromotionHref> banners) {
        List<ContentPromotionContent> contents = contentPromotionRepository.getContentPromotion(clientId,
                mapList(banners, BannerWithContentPromotionHref::getContentPromotionId));
        return StreamEx.of(contents).toMap(ContentPromotionContent::getId, ContentPromotionContent::getUrl);
    }
}
