package ru.yandex.direct.core.entity.banner.type.href;

import ru.yandex.direct.core.entity.uac.service.trackingurl.TrackingUrlParseService;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.entity.banner.type.href.BannerWithHrefConstraints.validTrackingSystem;

public class BannerHrefTrackingSystemValidator implements Validator<String, Defect> {

    private final TrackingUrlParseService trackingUrlParseService;

    public BannerHrefTrackingSystemValidator(TrackingUrlParseService trackingUrlParseService) {
        this.trackingUrlParseService = trackingUrlParseService;
    }

    @Override
    public ValidationResult<String, Defect> apply(String href) {
        ItemValidationBuilder<String, Defect> builder = ItemValidationBuilder.of(href);
        return builder
                .check(validTrackingSystem(trackingUrlParseService))
                .getResult();
    }
}
