package ru.yandex.direct.core.entity.banner.type.href;

import javax.annotation.Nullable;

import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.entity.banner.type.href.BannerWithHrefConstraints.hrefHasValidLength;
import static ru.yandex.direct.core.entity.banner.type.href.BannerWithHrefConstraints.hrefIsNotBlank;
import static ru.yandex.direct.core.entity.banner.type.href.BannerWithHrefConstraints.hrefIsValid;

public class BannerHrefValidator implements Validator<String, Defect> {

    @Nullable
    private final Defect hrefIsNotBlankDefect;

    public BannerHrefValidator() {
        this(null);
    }

    public BannerHrefValidator(@Nullable Defect hrefIsNotBlankDefect) {
        this.hrefIsNotBlankDefect = hrefIsNotBlankDefect;
    }

    @Override
    public ValidationResult<String, Defect> apply(String href) {
        ItemValidationBuilder<String, Defect> builder = ItemValidationBuilder.of(href);

        if (hrefIsNotBlankDefect != null) {
            builder.check(hrefIsNotBlank(), hrefIsNotBlankDefect);
        } else {
            builder.check(hrefIsNotBlank());
        }

        builder
                .check(hrefHasValidLength(), When.isValid())
                .check(hrefIsValid(), When.isValid());

        return builder.getResult();
    }
}
