package ru.yandex.direct.core.entity.banner.type.href;

import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.entity.banner.type.href.BannerWithHrefConstraints.trackingUrlContainsLogidMacros;

public class BannerTrackingHrefMacrosValidator implements Validator<String, Defect> {


    @Override
    public ValidationResult<String, Defect> apply(String href) {
        ItemValidationBuilder<String, Defect> builder = ItemValidationBuilder.of(href);
        return builder
                .weakCheck(trackingUrlContainsLogidMacros())
                .getResult();
    }
}
