package ru.yandex.direct.core.entity.banner.type.href;

import ru.yandex.direct.core.entity.trustedredirects.service.TrustedRedirectsService;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.entity.banner.type.href.BannerWithHrefConstraints.validTrackingHref;

public class BannerTrackingHrefValidator implements Validator<String, Defect> {

    private final TrustedRedirectsService trustedRedirectsService;

    public BannerTrackingHrefValidator(TrustedRedirectsService trustedRedirectsService) {
        this.trustedRedirectsService = trustedRedirectsService;
    }

    @Override
    public ValidationResult<String, Defect> apply(String href) {
        ItemValidationBuilder<String, Defect> builder = ItemValidationBuilder.of(href);
        return builder
                .check(validTrackingHref(trustedRedirectsService))
                .getResult();
    }
}
