package ru.yandex.direct.core.entity.banner.type.href;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithContentPromotionHref;
import ru.yandex.direct.core.entity.banner.service.type.add.AbstractBannerAddOperationTypeSupport;

@Component
public class BannerWithContentPromotionHrefAddOperationTypeSupport
        extends AbstractBannerAddOperationTypeSupport<BannerWithContentPromotionHref> {

    private final BannerHrefByContentPromotionEvaluator evaluator;

    @Autowired
    public BannerWithContentPromotionHrefAddOperationTypeSupport(
            BannerHrefByContentPromotionEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    @Override
    public Class<BannerWithContentPromotionHref> getTypeClass() {
        return BannerWithContentPromotionHref.class;
    }

    @Override
    public void onModelsValidated(BannersAddOperationContainer container, List<BannerWithContentPromotionHref> models) {
        // В BannerWithHrefAddOperationTypeSupport.beforeExecute() обязательно нужен уже заполненный href
        evaluator.setBannersHrefsByContentPromotion(container.getClientId(), models);
    }
}
