package ru.yandex.direct.core.entity.banner.type.href;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithContentPromotionHref;
import ru.yandex.direct.core.entity.banner.service.type.update.AbstractBannerUpdateOperationTypeSupport;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.model.BannerWithContentPromotionHref.CONTENT_PROMOTION_ID;
import static ru.yandex.direct.utils.FunctionalUtils.filterList;

@Component
public class BannerWithContentPromotionHrefUpdateOperationTypeSupport
        extends AbstractBannerUpdateOperationTypeSupport<BannerWithContentPromotionHref> {
    private final BannerHrefByContentPromotionEvaluator evaluator;

    @Autowired
    public BannerWithContentPromotionHrefUpdateOperationTypeSupport(
            BannerHrefByContentPromotionEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    @Override
    public Class<BannerWithContentPromotionHref> getTypeClass() {
        return BannerWithContentPromotionHref.class;
    }

    @Override
    public void onAppliedChangesValidated(BannersUpdateOperationContainer container,
                                          List<AppliedChanges<BannerWithContentPromotionHref>> appliedChanges) {
        // В BannerWithHrefUpdateOperationTypeSupport.beforeExecution() href уже должен быть заполнен
        evaluator.setBannersChangesHrefsByContentPromotion(container.getClientId(),
                filterList(appliedChanges, item -> item.changed(CONTENT_PROMOTION_ID)));
    }
}
