package ru.yandex.direct.core.entity.banner.type.href;

import java.util.List;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannerAdditionalActionsContainer;
import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithHref;
import ru.yandex.direct.core.entity.banner.service.type.add.AbstractBannerAddOperationTypeSupport;

import static ru.yandex.direct.utils.FunctionalUtils.filterList;

@Component
public class BannerWithHrefAddOperationTypeSupport extends AbstractBannerAddOperationTypeSupport<BannerWithHref> {

    private final BannerHrefAndDomainProcessor processor;

    @Autowired
    public BannerWithHrefAddOperationTypeSupport(BannerHrefAndDomainProcessor processor) {
        this.processor = processor;
    }

    @Override
    public Class<BannerWithHref> getTypeClass() {
        return BannerWithHref.class;
    }

    @Override
    public void beforeExecution(BannersAddOperationContainer container, List<BannerWithHref> models) {
        processor.processBannersHrefs(filterList(models, banner -> banner.getHref() != null));

        processor.processBannersDomains(
                models, container.getOperatorRole().isInternal() || container.isCopy());

        processor.storeBannersDomainsAndSetDomainIds(container.getShard(),
                filterList(models, banner -> banner.getDomain() != null));
    }

    @Override
    public void addToAdditionalActionsContainer(BannerAdditionalActionsContainer additionalActionsContainer,
                                                BannersAddOperationContainer container, List<BannerWithHref> models) {
        additionalActionsContainer.addAdGroupsIdsForBSResync(
                processor.getAdGroupsToResendToBS(filterList(models, banner -> banner.getHref() != null)));
    }

    @Override
    public void updateRelatedEntitiesInTransaction(DSLContext dslContext, BannersAddOperationContainer container,
                                                   List<BannerWithHref> models) {
        processor.updateFilterDomain(dslContext, filterList(models, banner -> banner.getDomain() != null));

        processor.setAdGroupsHasPhraseIdHref(dslContext, filterList(models, banner -> banner.getHref() != null),
                container.getAdGroups());
    }

    @Override
    public void afterExecution(BannersAddOperationContainer container, List<BannerWithHref> models) {
        processor.addBannersToRedirectCheckQueue(container.getShard(),
                filterList(models, banner -> banner.getDomain() != null));
    }

}
