package ru.yandex.direct.core.entity.banner.type.href;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithHref;
import ru.yandex.direct.core.entity.banner.model.ContentPromotionBanner;
import ru.yandex.direct.core.entity.banner.service.validation.type.add.AbstractBannerAddValidationTypeSupport;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.banner.model.BannerWithHref.DOMAIN;
import static ru.yandex.direct.core.entity.banner.model.BannerWithHref.DOMAIN_ID;
import static ru.yandex.direct.core.entity.banner.model.BannerWithHref.HREF;
import static ru.yandex.direct.core.entity.banner.type.href.BannerWithHrefConstraints.domainMatchesAllowedPattern;
import static ru.yandex.direct.validation.constraint.CommonConstraints.isNull;
import static ru.yandex.direct.validation.constraint.StringConstraints.notEmpty2;

@Component
public class BannerWithHrefAddValidationTypeSupport
        extends AbstractBannerAddValidationTypeSupport<BannerWithHref> {


    private final BannerWithHrefValidatorProvider validatorProvider;

    @Autowired
    public BannerWithHrefAddValidationTypeSupport(BannerWithHrefValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    @Override
    public Class<BannerWithHref> getTypeClass() {
        return BannerWithHref.class;
    }

    @Override
    public ValidationResult<List<BannerWithHref>, Defect> preValidate(BannersAddOperationContainer container,
                                                                      ValidationResult<List<BannerWithHref>,
                                                                                 Defect> vr) {

        ListValidationBuilder<BannerWithHref, Defect> lvb = new ListValidationBuilder<>(vr);

        lvb.checkEachBy(banner -> {
            ModelItemValidationBuilder<BannerWithHref> vb = ModelItemValidationBuilder.of(banner);

            if (banner instanceof ContentPromotionBanner) {
                vb.item(HREF).check(isNull());
                vb.item(DOMAIN).check(isNull());
                vb.item(DOMAIN_ID).check(isNull());

                return vb.getResult();
            }

            vb.item(DOMAIN)
                    .check(notEmpty2(), When.isValid())
                    .check(domainMatchesAllowedPattern(), When.isValid());

            return vb.getResult();
        });

        return lvb.getResult();
    }

    @Override
    public ValidationResult<List<BannerWithHref>, Defect> validate(
            BannersAddOperationContainer container, ValidationResult<List<BannerWithHref>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.bannerWithHrefValidator(container))
                .getResult();
    }
}
