package ru.yandex.direct.core.entity.banner.type.href;

import java.util.regex.Pattern;

import ru.yandex.direct.core.entity.banner.service.validation.BannerTextConstants;

public class BannerWithHrefConstants {

    /**
     * Максимальная длина ссылки без учёта вхождения шаблонных меток {@link BannerTextConstants#TEMPLATE_MARKER_SYMBOL}
     * (самостоятельный диез учитывается)
     */
    public static final int MAX_LENGTH_HREF = 1024;
    /**
     * Паттерн для проверки домена на валидность
     */
    public static final Pattern DOMAIN_PATTERN = Pattern.compile(
            "^(?:[\\p{Alpha}0-9][\\p{Alpha}0-9\\-_]{0,62}\\.)+\\p{Alpha}[\\p{Alpha}0-9\\-]{1,14}\\z",
            Pattern.UNICODE_CHARACTER_CLASS);

    static final String LOGID_MACROS = "logid";
    static final String DOMAIN_FOR_ADJUST = "app.adjust.com";
    static final String DOMAIN_FOR_ADJUST_IMPRESSION = "view.adjust.com";

    private BannerWithHrefConstants() {
        // only for static members
    }
}
