package ru.yandex.direct.core.entity.banner.type.href;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithHref;
import ru.yandex.direct.core.entity.banner.model.ContentPromotionBanner;
import ru.yandex.direct.core.entity.banner.model.MobileAppBanner;
import ru.yandex.direct.core.entity.banner.service.validation.type.update.AbstractBannerUpdateValidationTypeSupport;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelChangesValidationBuilder;

import static ru.yandex.direct.core.entity.banner.model.BannerWithHref.DOMAIN;
import static ru.yandex.direct.core.entity.banner.model.BannerWithHref.DOMAIN_ID;
import static ru.yandex.direct.core.entity.banner.model.BannerWithHref.HREF;
import static ru.yandex.direct.core.entity.banner.type.href.BannerWithHrefConstraints.domainMatchesAllowedPattern;
import static ru.yandex.direct.core.validation.ValidationUtils.addErrorIfPropertyChanged;
import static ru.yandex.direct.core.validation.defects.RightsDefects.noRights;
import static ru.yandex.direct.validation.constraint.StringConstraints.notEmpty2;

@Component
public class BannerWithHrefUpdateValidationTypeSupport
        extends AbstractBannerUpdateValidationTypeSupport<BannerWithHref> {


    private final BannerWithHrefValidatorProvider validatorProvider;

    @Autowired
    public BannerWithHrefUpdateValidationTypeSupport(BannerWithHrefValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    @Override
    public Class<BannerWithHref> getTypeClass() {
        return BannerWithHref.class;
    }

    @Override
    public ValidationResult<List<ModelChanges<BannerWithHref>>, Defect> preValidate(
            BannersUpdateOperationContainer container,
            ValidationResult<List<ModelChanges<BannerWithHref>>, Defect> vr) {

        ListValidationBuilder<ModelChanges<BannerWithHref>, Defect> lvb = new ListValidationBuilder<>(vr);

        lvb.checkEachBy(mc -> {
            ModelChangesValidationBuilder<BannerWithHref> vb = ModelChangesValidationBuilder.of(mc);

            if (ContentPromotionBanner.class.isAssignableFrom(container.getRuntimeClass(mc.getId()))) {
                addErrorIfPropertyChanged(mc, vb, HREF);
                addErrorIfPropertyChanged(mc, vb, DOMAIN);
                addErrorIfPropertyChanged(mc, vb, DOMAIN_ID);

                return vb.getResult();
            }


            if (container.isOperatorInternal()
                    || MobileAppBanner.class.isAssignableFrom(container.getRuntimeClass(mc.getId()))) {
                vb.item(DOMAIN)
                        .check(notEmpty2(), When.isValid())
                        .check(domainMatchesAllowedPattern(), When.isValid());
            } else {
                addErrorIfPropertyChanged(mc, vb, DOMAIN, noRights());
            }

            return vb.getResult();
        });

        return lvb.getResult();
    }

    @Override
    public ValidationResult<List<BannerWithHref>, Defect> validate(
            BannersUpdateOperationContainer container, ValidationResult<List<BannerWithHref>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.bannerWithHrefValidator(container))
                .getResult();
    }
}
