package ru.yandex.direct.core.entity.banner.type.href;

import java.net.IDN;
import java.util.function.Predicate;
import java.util.regex.Pattern;

import javax.annotation.Nullable;


public class BannerWithHrefUtils {

    private static final Pattern HAS_COEF_GOAL_CONTEXT_ID_HREF = Pattern.compile("\\{coef_goal_context_id}");
    private static final Pattern HAS_PHRASEID_HREF =
            Pattern.compile("\\{(phrase_id|phraseid|param127|retargeting_id)}");

    public static final Predicate<String> HREF_HAS_COEF_GOAL_CONTEXT_ID =
            href -> HAS_COEF_GOAL_CONTEXT_ID_HREF.matcher(href).find();
    public static final Predicate<String> HREF_HAS_PHRASEID = href -> HAS_PHRASEID_HREF.matcher(href).find();

    public static final String FIELD_TRACKING_URL = "trackingUrl";

    @Nullable
    public static String toUnicodeDomain(@Nullable String domain) {
        if (domain != null) {
            domain = IDN.toUnicode(domain);
        }
        return domain;
    }


    private BannerWithHrefUtils() {
    }
}
