package ru.yandex.direct.core.entity.banner.type.image;

import java.util.List;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithImage;
import ru.yandex.direct.core.entity.banner.model.NewStatusImageModerate;
import ru.yandex.direct.core.entity.banner.service.type.add.AbstractBannerAddOperationTypeSupport;

import static ru.yandex.direct.core.entity.banner.service.BannerModerationUtils.isEffectiveSaveDraft;

@Component
public class BannerWithImageAddOperationTypeSupport
        extends AbstractBannerAddOperationTypeSupport<BannerWithImage> {

    @Override
    public Class<BannerWithImage> getTypeClass() {
        return BannerWithImage.class;
    }

    @Override
    public void beforeExecution(BannersAddOperationContainer addContainer, List<BannerWithImage> models) {
        models.forEach(banner -> fillSystemFields(addContainer, banner));
    }

    private void fillSystemFields(BannersAddOperationContainer addContainer, BannerWithImage banner) {
        var effectiveSaveDraft = isEffectiveSaveDraft(addContainer, banner);

        if (banner.getImageHash() != null) {
            banner.withImageId(null)
                    .withImageStatusModerate(
                            effectiveSaveDraft ? NewStatusImageModerate.NEW : NewStatusImageModerate.READY);
        }
    }
}
