package ru.yandex.direct.core.entity.banner.type.image;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithImage;
import ru.yandex.direct.core.entity.banner.service.validation.type.add.AbstractBannerAddValidationTypeSupport;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
public class BannerWithImageAddValidationTypeSupport
        extends AbstractBannerAddValidationTypeSupport<BannerWithImage> {

    private final BannerWithImageValidatorProvider validatorProvider;

    @Autowired
    public BannerWithImageAddValidationTypeSupport(
            BannerWithImageValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    @Override
    public Class<BannerWithImage> getTypeClass() {
        return BannerWithImage.class;
    }


    @Override
    public ValidationResult<List<BannerWithImage>, Defect> validate(
            BannersAddOperationContainer container,
            ValidationResult<List<BannerWithImage>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.imageValidator(container))
                .getResult();
    }
}
