package ru.yandex.direct.core.entity.banner.type.image;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithImageAndCreative;
import ru.yandex.direct.core.entity.banner.service.validation.type.add.AbstractBannerAddValidationTypeSupport;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
public class BannerWithImageAndCreativeAddValidationTypeSupport
        extends AbstractBannerAddValidationTypeSupport<BannerWithImageAndCreative> {

    private final BannerWithImageAndCreativeValidatorProvider validatorProvider;

    @Autowired
    public BannerWithImageAndCreativeAddValidationTypeSupport(
            BannerWithImageAndCreativeValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    @Override
    public Class<BannerWithImageAndCreative> getTypeClass() {
        return BannerWithImageAndCreative.class;
    }

    @Override
    public ValidationResult<List<BannerWithImageAndCreative>, Defect> validate(
            BannersAddOperationContainer container,
            ValidationResult<List<BannerWithImageAndCreative>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.imageAndCreativeValidator())
                .getResult();
    }
}
